* 03a addliquid_credit (Figure 9).do
*version 17
#d ;
cap log close;
set more off;
set linesize 120;
set type double;
set scheme s1color;

cap log close;
log using "${log}addliquidcredit_apr26.log", replace;

use "${CE}ce_cpc_comb_haall_v7.dta", clear;	//adjb uses 15 grp inc imputation;
count;
*define asset universe;
keep if asecsurvey==0 & year>=2004 & assetintrv==1 ;   //only non missing assets, zeros are allowed, nonmissing credit uses same intrv sample;

gen elderref=age_ref>65 & asecsurvey==0;
label var elderref "Elder Ref person (age>65)";
gen bottomquint= (ccgrp ==11 | ccgrp==12 | ccgrp==13);

* liq asset indicator;
gen liqpos=.;
replace liqpos=(rliquidasset4>0 & rliquidasset4<.);
replace liqpos=0 if rliquidasset4==0;

* new credit limits from scf data;
gen credpos=0;
replace credpos=(rcreditcd4>0 & icc_limit<.);

gen nocard = icc_limit==0 & icc_limit<.;
gen credzero=.;
replace credzero= rcreditcd4==0 & icc_limit>0 & icc_limit<.;
gen credcur=.;
replace credcur=rcreditcd4/icc_limita if icc_limita>0;

gen addrcredit1 = icc_limit-rcreditcd4; //limit not based on CUR;
replace addrcredit1=0 if addrcredit1<0;
gen addrcredit2 = icc_limita-rcreditcd4; //limit based on CUR;
replace addrcredit2=0 if addrcredit2<0;

*table ccgrp [aweight=c_perpopwt], stat(mean add* icchave credpos);

* define resources;

gen ce_rexpkb=c_rexpk if asec==0;  // do not adjust for repayment since not counted as expenditure in ce;
gen ce_rinck=c_rinck if asec==0;

gen ce_prexpkb=ce_rexpkb<c_rspm_thres;

gen ce_rexpk_wliq=(ce_rexpkb + rliquidasset4 ) ;	//add imputed credit balance paid ;
gen ce_prexpk_wliq = (ce_rexpk_wliq < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wliq=(ce_rinck + rliquidasset4 ) ;
gen ce_princk_wliq = (ce_rinck_wliq < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wc=(ce_rexpkb + addrcredit2 ) ;	//add imputed credit balance paid ;
gen ce_prexpk_wc = (ce_rexpk_wc < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wc=(ce_rinck + addrcredit2 ) ;
gen ce_princk_wc = (ce_rinck_wc < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wliqc=(ce_rexpkb + rliquidasset4 + addrcredit2) ;
gen ce_prexpk_wliqc = (ce_rexpk_wliqc < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wliqc=(ce_rinck + rliquidasset4 + addrcredit2) ;
gen ce_princk_wliqc = (ce_rinck_wliqc < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wc1=(ce_rexpkb + addrcredit1 ) ;	
gen ce_prexpk_wc1 = (ce_rexpk_wc1 < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wc1=(ce_rinck + addrcredit1 ) ;
gen ce_princk_wc1 = (ce_rinck_wc1 < c_rspm_thres) & rliquidasset4<. ;

gen ce_rexpk_wliqc1=(ce_rexpkb + rliquidasset4 + addrcredit1) ;
gen ce_prexpk_wliqc1 = (ce_rexpk_wliqc1 < c_rspm_thres) & rliquidasset4<. ;
gen ce_rinck_wliqc1=(ce_rinck + rliquidasset4 + addrcredit1) ;
gen ce_princk_wliqc1 = (ce_rinck_wliqc1 < c_rspm_thres) & rliquidasset4<. ;

replace ce_princk_wliqc=. if rliquidasset4==.|rcreditcd4==.;
replace ce_prexpk_wliqc=. if rliquidasset4==.|rcreditcd4==.;
replace ce_princk_wliqc1=. if rliquidasset4==.|rcreditcd4==.;
replace ce_prexpk_wliqc1=. if rliquidasset4==.|rcreditcd4==.;


preserve;
collapse (mean) ce_prexpk_fmwc ce_prexpkb ce_princk_tmwc ce_prexpk_wliqc ce_prexpk_wc ce_princk_wc ce_princk_wliqc ce_prexpk_wliq ce_princk_wliq ce_princk_wc1 ce_princk_wliqc1 ce_prexpk_wliqc1 ce_prexpk_wc1 ///
 [aweight=c_perpopwt] if rliquidasset4<. , by(asecsurvey year) ;

for var ce_prexpk_fmwc ce_prexpk_wliq ce_prexpk_wliqc : replace X = X * 100;

twoway (line ce_prexpk_fmwc year if asecsurvey==0, color(red))  ///
(line ce_prexpk_wliqc year if asecsurvey==0, color(red) lp(dash)) ///
(line ce_prexpk_wliq year if asecsurvey==0, color(red) lp(shortdash_dot)), ///
ytitle("Poverty Rate (%)" "") ylabel(,labsize(small) angle(0)) ylabel(5(5)20, format(%3.0fc) labsize(small) angle(0))
title("Figure 9: Net SEPM Poverty Rates With and Without" "Liquid Assets & Unused Credit, 2004–2019" " ", size(11pt)) ///
legend(size(7pt) label(1 "Net SEPM") ///
label(3 "Net SEPM w/ Liquid Assets") label(2 "Net SEPM w/ Liquid Assets & Unused Credit")) ///
note("Notes: SEPM based on adjusted expenditure < SPM threshold. Resources include SNAP and three in-kind transfers and excludes three types" ///
"of capped adjustments (work-related and child care costs, child support paid, and medical out of pocket expense. SEPM with geographic cost" /// 
"of living adjustment is used. Liquid Assets include checking and savings account balances. Unused credit is imputed from the SCF based on" ///
"income, age, and credit utilization rate.", size(vsmall) span) ///
saving("${outgraph}03a SEPM_liqc2_trend (Figure 9 C).gph", replace);
graph export "${outgraph}03a SEPM_liqc2_trend (Figure 9 C).pdf",replace;

twoway (line ce_prexpk_fmwc year if asecsurvey==0, color(gray))  ///
(line ce_prexpk_wliqc year if asecsurvey==0, color(gray) lp(dash)) ///
(line ce_prexpk_wliq year if asecsurvey==0, color(gray) lp(shortdash_dot)), ///
ytitle("Poverty Rate (%)" "") ylabel(,labsize(small) angle(0)) ylabel(5(5)20, format(%3.0fc) labsize(small) angle(0))
title("Figure 9: Net SEPM Poverty Rates With and Without" "Liquid Assets & Unused Credit, 2004–2019" " ", size(11pt)) ///
legend(size(7pt) label(1 "Net SEPM") ///
label(3 "Net SEPM w/ Liquid Assets") label(2 "Net SEPM w/ Liquid Assets & Unused Credit")) ///
note("Notes: SEPM based on adjusted expenditure < SPM threshold. Resources include SNAP and three in-kind transfers and excludes three types" ///
"of capped adjustments (work-related and child care costs, child support paid, and medical out of pocket expense. SEPM with geographic cost" /// 
"of living adjustment is used. Liquid Assets include checking and savings account balances. Unused credit is imputed from the SCF based on" ///
"income, age, and credit utilization rate.", size(vsmall) span) ///
saving("${outgraph}03a SEPM_liqc2_trend (Figure 9 BW).gph", replace);
graph export "${outgraph}03a SEPM_liqc2_trend (Figure 9 BW).pdf",replace;

restore;

log close;

